/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.ert.v_3.v2.builder.OrderQueryBuilder;
import com.upay.sdk.ert.v_3.v2.builder.ReceiptOrderBuilder;
import com.upay.sdk.ert.v_3.v2.builder.ReceiptPaymentBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiptOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ReceiptOrderExecuter.class);

    public void bothOrder(ReceiptOrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getErtReceiptOrderUrlV2(), requestData);
            LOGGER.info("responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("responseStr:[" + responseData + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothQuery(OrderQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getErtOrderQueryUrlV2(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.info("responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
        }
        catch (Exception e) {
            LOGGER.error("bothQuery order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void bothPayment(ReceiptPaymentBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("ert bothPayment requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getErtReceiptPaymentUrlV2(), requestData);
            LOGGER.info("ert bothPayment responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("ert bothPayment responseStr:[" + responseData + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("ert bothPayment request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

