/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eshopping.vcc.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class VccExpenseCreateBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String cardNo;
    private String transactionStartTime;
    private String transactionEndTime;

    public VccExpenseCreateBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public VccExpenseCreateBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTransactionStartTime() {
        return this.transactionStartTime;
    }

    public void setTransactionStartTime(String transactionStartTime) {
        this.transactionStartTime = transactionStartTime;
    }

    public String getTransactionEndTime() {
        return this.transactionEndTime;
    }

    public void setTransactionEndTime(String transactionEndTime) {
        this.transactionEndTime = transactionEndTime;
    }

    public VccExpenseCreateBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }
}

