/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.foreignexchange.executer;

import com.alibaba.fastjson15.JSON;
import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.HmacArray;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.foreignexchange.builder.ListpriceLockBuilder;
import com.upay.sdk.foreignexchange.builder.OrderBuilder;
import com.upay.sdk.foreignexchange.builder.QueryBuilder;
import com.upay.sdk.foreignexchange.builder.RefundBuilder;
import com.upay.sdk.foreignexchange.builder.RefundQueryBuilder;
import com.upay.sdk.foreignexchange.builder.TransferOrderBuilder;
import com.upay.sdk.foreignexchange.builder.TransferQueryBuilder;
import com.upay.sdk.transfer.ConstantsTransfer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignExchangeOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ForeignExchangeOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS, "redirectUrl", Constants.SCANCODE, Constants.APPPARAMS};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "totalRefundCount", "totalRefundAmount", "orderCurrency", "orderAmount", "remark", "payment.amount", "payment.currency", "payment.status", "payment.completeDateTime", "payment.bindCardId", "foreignExchange.amount", "foreignExchange.currency", "foreignExchange.status", "foreignExchange.listprice", "foreignExchange.deductionAmount", "foreignExchange.completeDateTime", HmacArray.create("subOrders", new String[]{Constants.REQUEST_ID, "orderAmount", Constants.SERIAL_NUMBER})};
    static final String[] REFUND_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "orderId", Constants.STATUS, "errorCode", "errorMessage", "amount", "currency", "completeDateTime"};
    static final String[] LISTPRICE_LOCK_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, "serialNumber", "listprice", "validity", "effective", Constants.STATUS};
    static final String[] TRANSFER_ORDER_RESPONSE_HMAC_FIELDS = new String[]{ConstantsTransfer.MERCHANT_ID, ConstantsTransfer.REQUEST_ID, ConstantsTransfer.STATUS};
    static final Object[] TRANSFER_QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "currency", "amount", Constants.STATUS, "completeDateTime"};

    public void order(JSONObject requestData, ResultListener resultListener) {
        block4: {
            try {
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignExchangeOrderUrl(), requestData.toJSONString());
                LOGGER.debug("responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block4;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block4;
                }
                throw new ResponseException(responseData);
            }
            catch (IOException e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void orderV_2(OrderBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.debug("ForeignExchangeOrderExecuter orderV_2 requestData:[" + requestData.toJSONString() + "],ForeignExchangeOrderUrl:[" + ConfigurationUtils.getForeignExchangeOrderUrl() + "]");
                String responseStr = HttpClientUtils.post2(ConfigurationUtils.getForeignExchangeOrderUrl(), requestData);
                LOGGER.debug("ForeignExchangeOrderExecuter orderV_2 responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.decryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.verifyHmacOrder(responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block5;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (IOException e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void query(JSONObject requestData, ResultListener paymentListener, ResultListener foreignExchangeListener) {
        if (paymentListener == null || foreignExchangeListener == null) {
            throw new NullPointerException();
        }
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignExchangeQueryUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.callback(responseData, paymentListener, foreignExchangeListener);
    }

    public void queryV_2(QueryBuilder builder, ResultListener paymentListener, ResultListener foreignExchangeListener) {
        if (paymentListener == null || foreignExchangeListener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("ForeignExchangeOrderExecuter queryV_2 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getForeignExchangeQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.debug("ForeignExchangeOrderExecuter queryV_2 responseStr:[" + responseStr + "]");
            this.callbackV_2(responseData, paymentListener, foreignExchangeListener);
        }
        catch (Exception e) {
            LOGGER.error("ForeignExchangeOrderExecuter queryv_2 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void callback(JSONObject responseData, ResultListener paymentListener, ResultListener foreignExchangeListener) {
        JSONObject foreignExchangeJson;
        if (paymentListener == null || foreignExchangeListener == null) {
            throw new NullPointerException();
        }
        LOGGER.info("ForeignExchangeOrderExecuter responseData:[" + responseData + "]");
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        JSONObject paymentJson = responseData.getJSONObject("payment");
        if (paymentJson != null) {
            String status = paymentJson.getString(Constants.STATUS);
            if (Constants.SUCCESS.equals(status)) {
                paymentListener.success(responseData);
            } else {
                if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                    paymentListener.failure(responseData);
                    return;
                }
                if (Constants.INIT.equals(status)) {
                    paymentListener.pending(responseData);
                    return;
                }
                throw new ResponseException(responseData);
            }
        }
        if ((foreignExchangeJson = responseData.getJSONObject("foreignExchange")) != null) {
            String status = foreignExchangeJson.getString(Constants.STATUS);
            if (Constants.SUCCESS.equals(status)) {
                foreignExchangeListener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                foreignExchangeListener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                foreignExchangeListener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
        if (paymentJson == null && foreignExchangeJson == null) {
            LOGGER.info("do nothing.", (Object)responseData);
        }
    }

    public void callbackV_2(JSONObject responseData, ResultListener paymentListener, ResultListener foreignExchangeListener) {
        JSONObject foreignExchangeJson;
        LOGGER.info("ForeignExchangeOrderExecuter callbackV_2 responseData:[" + responseData + "]");
        if (paymentListener == null || foreignExchangeListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        LOGGER.info("ForeignExchangeOrderExecuter callbackV_2 data:[" + data + "]");
        this.verifyHmacOrder(data);
        JSONObject paymentJson = data.getJSONObject("payment");
        if (paymentJson != null) {
            String status = paymentJson.getString(Constants.STATUS);
            if (Constants.SUCCESS.equals(status)) {
                paymentListener.success(data);
            } else {
                if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                    paymentListener.failure(data);
                    return;
                }
                if (Constants.INIT.equals(status)) {
                    paymentListener.pending(data);
                    return;
                }
                throw new ResponseException(data);
            }
        }
        if ((foreignExchangeJson = data.getJSONObject("foreignExchange")) != null) {
            String status = foreignExchangeJson.getString(Constants.STATUS);
            if (Constants.SUCCESS.equals(status)) {
                foreignExchangeListener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                foreignExchangeListener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                foreignExchangeListener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
        if (paymentJson == null && foreignExchangeJson == null) {
            LOGGER.info("do nothing.", (Object)responseData);
        }
    }

    public void refund(JSONObject requestData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignExchangeRefundUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.verifyHmac(REFUND_RESPONSE_HMAC_FIELDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void refundV_2(RefundBuilder builder, ResultListener listener) {
        block6: {
            if (listener == null) {
                throw new NullPointerException();
            }
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.info("ForeignExchangeOrderExecuter refundV_2 requestData:[" + requestData + "]");
                String responseStr = HttpClientUtils.post2(ConfigurationUtils.getForeignExchangeRefundUrl(), requestData);
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                LOGGER.info("responseData:[" + responseData + "]");
                JSONObject data = CipherWrapper.decryptWrap(responseData);
                this.verifyHmacOrder(data);
                String status = data.getString(Constants.STATUS);
                if (Constants.SUCCESS.equals(status)) {
                    listener.success(data);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    listener.failure(data);
                    break block6;
                }
                if (Constants.INIT.equals(status)) {
                    listener.pending(data);
                    break block6;
                }
                throw new ResponseException(data);
            }
            catch (Exception e) {
                LOGGER.error("ForeignExchangeOrderExecuter refundv_2 exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void refundCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.verifyHmac(REFUND_RESPONSE_HMAC_FIELDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void refundCallbackV_2(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(data);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(data);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(data);
        } else {
            throw new ResponseException(data);
        }
    }

    public void refundQuery(JSONObject requestData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignExchangeRefundQueryUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.refundCallback(responseData, listener);
    }

    public void refundQueryV_2(RefundQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject requestData = builder.encryptBuild();
        LOGGER.debug("ForeignExchangeOrderExecuter refundVQuery_2 requestData:[" + requestData + "]");
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getForeignExchangeRefundQueryUrl(), requestData);
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.refundCallbackV_2(responseData, listener);
    }

    public void lock(JSONObject requestData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignExchangeListpriceLockUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.verifyHmac(LISTPRICE_LOCK_RESPONSE_HMAC_FIELDS, responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        listener.success(responseData);
    }

    public void lockV_2(ListpriceLockBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject requestData = builder.encryptBuild();
        LOGGER.info("ForeignExchangeOrderExecuter lockV_2 requestData:[" + requestData + "]");
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getForeignExchangeListpriceLockUrl(), requestData);
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        LOGGER.info("responseStr:[" + responseData + "]");
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        LOGGER.info("ForeignExchangeOrderExecuter lockV_2 data:[" + data + "]");
        this.verifyHmacOrder(data);
        if (!Constants.SUCCESS.equals(data.getString(Constants.STATUS))) {
            throw new ResponseException(data);
        }
        listener.success(data);
    }

    public void transferOrder(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignExchangeTransferOrderUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.verifyHmac(TRANSFER_ORDER_RESPONSE_HMAC_FIELDS, responseData);
        if (!ConstantsTransfer.SUCCESS.equals(responseData.getString(ConstantsTransfer.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void transferOrderV_2(TransferOrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("ForeignExchangeOrderExecuter transferOrderV_2 requestData:[" + requestData.toJSONString() + "],ForeignExchangeTransferOrderUrl:[" + ConfigurationUtils.getForeignExchangeTransferOrderUrl() + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getForeignExchangeTransferOrderUrl(), requestData);
            LOGGER.debug("ForeignExchangeOrderExecuter transferOrderV_2 responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.decryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.verifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request transferOrderV_2 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void transferQuery(JSONObject requestData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post(ConfigurationUtils.getForeignExchangeTransferQueryUrl(), requestData.toJSONString());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            this.transferCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void transferQueryV_2(TransferQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("ForeignExchangeOrderExecuter transferQueryV_2 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getForeignExchangeTransferQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.debug("ForeignExchangeOrderExecuter transferQueryV_2 responseStr:[" + responseStr + "]");
            this.transferCallbackV_2(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("ForeignExchangeOrderExecuter transferQueryV_2 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void transferCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.verifyHmac(TRANSFER_QUERY_RESPONSE_HMAC_FIELDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (ConstantsTransfer.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (ConstantsTransfer.FAILED.equals(status) || ConstantsTransfer.CANCEL.equals(status)) {
            listener.failure(responseData);
        } else if (ConstantsTransfer.INIT.equals(status) || ConstantsTransfer.PROCESSING.equals(status) || ConstantsTransfer.PAID.equals(status) || ConstantsTransfer.REMITTED.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void transferCallbackV_2(JSONObject responseData, ResultListener listener) {
        LOGGER.info("ForeignExchangeOrderExecuter transferCallbackV_2 responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        LOGGER.info("ForeignExchangeOrderExecuter transferCallbackV_2 data:[" + data + "]");
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (ConstantsTransfer.SUCCESS.equals(status)) {
            listener.success(data);
        } else if (ConstantsTransfer.FAILED.equals(status) || ConstantsTransfer.CANCEL.equals(status)) {
            listener.failure(data);
        } else if (ConstantsTransfer.INIT.equals(status) || ConstantsTransfer.PROCESSING.equals(status) || ConstantsTransfer.PAID.equals(status) || ConstantsTransfer.REMITTED.equals(status)) {
            listener.pending(data);
        } else {
            throw new ResponseException(data);
        }
    }

    public void orderV_3(OrderBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                LOGGER.debug("ForeignExchangeOrderExecuter orderV_3 builder:[" + JSON.toJSONString(builder) + "]");
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("ForeignExchangeOrderExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],ForeignExchangeOrderUrl:[" + ConfigurationUtils.getForeignExchangeOrderUrl() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignExchangeOrderUrl(), requestData);
                LOGGER.debug("ForeignExchangeOrderExecuter orderV_3 responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.bothVerifyHmacOrder(responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block5;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (IOException e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void lockV_3(ListpriceLockBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("ForeignExchangeOrderExecuter lockV_3 requestData:[" + requestData + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignExchangeListpriceLockUrl(), requestData);
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        LOGGER.info("responseStr:[" + responseData + "]");
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("ForeignExchangeOrderExecuter lockV_3 data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        if (!Constants.SUCCESS.equals(data.getString(Constants.STATUS))) {
            throw new ResponseException(data);
        }
        listener.success(data);
    }

    public void callbackV_3(JSONObject responseData, ResultListener paymentListener, ResultListener foreignExchangeListener) {
        JSONObject foreignExchangeJson;
        LOGGER.info("ForeignExchangeOrderExecuter callbackV_2 responseData:[" + responseData + "]");
        if (paymentListener == null || foreignExchangeListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("ForeignExchangeOrderExecuter callbackV_2 data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        JSONObject paymentJson = data.getJSONObject("payment");
        if (paymentJson != null) {
            String status = paymentJson.getString(Constants.STATUS);
            if (Constants.SUCCESS.equals(status)) {
                paymentListener.success(data);
            } else {
                if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                    paymentListener.failure(data);
                    return;
                }
                if (Constants.INIT.equals(status)) {
                    paymentListener.pending(data);
                    return;
                }
                throw new ResponseException(data);
            }
        }
        if ((foreignExchangeJson = data.getJSONObject("foreignExchange")) != null) {
            String status = foreignExchangeJson.getString(Constants.STATUS);
            if (Constants.SUCCESS.equals(status)) {
                foreignExchangeListener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                foreignExchangeListener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                foreignExchangeListener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
        if (paymentJson == null && foreignExchangeJson == null) {
            LOGGER.info("do nothing.", (Object)responseData);
        }
    }

    public void refundV_3(RefundBuilder builder, ResultListener listener) {
        block6: {
            if (listener == null) {
                throw new NullPointerException();
            }
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("ForeignExchangeOrderExecuter refundV_2 requestData:[" + requestData + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignExchangeRefundUrl(), requestData);
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                LOGGER.info("responseData:[" + responseData + "]");
                JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
                this.bothVerifyHmacOrder(data);
                String status = data.getString(Constants.STATUS);
                if (Constants.SUCCESS.equals(status)) {
                    listener.success(data);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    listener.failure(data);
                    break block6;
                }
                if (Constants.INIT.equals(status)) {
                    listener.pending(data);
                    break block6;
                }
                throw new ResponseException(data);
            }
            catch (Exception e) {
                LOGGER.error("ForeignExchangeOrderExecuter refundv_2 exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void queryV_3(QueryBuilder builder, ResultListener paymentListener, ResultListener foreignExchangeListener) {
        if (paymentListener == null || foreignExchangeListener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("ForeignExchangeOrderExecuter queryV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignExchangeQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.debug("ForeignExchangeOrderExecuter queryV_3 responseStr:[" + responseStr + "]");
            this.callbackV_3(responseData, paymentListener, foreignExchangeListener);
        }
        catch (Exception e) {
            LOGGER.error("ForeignExchangeOrderExecuter queryv_3 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void refundCallbackV_3(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(data);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(data);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(data);
        } else {
            throw new ResponseException(data);
        }
    }

    public void refundQueryV_3(RefundQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("ForeignExchangeOrderExecuter refundVQuery_3 requestData:[" + requestData + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignExchangeRefundQueryUrl(), requestData);
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.refundCallbackV_3(responseData, listener);
    }

    public void transferOrderV_3(TransferOrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("ForeignExchangeOrderExecuter transferOrderV_3 requestData:[" + requestData.toJSONString() + "],ForeignExchangeTransferOrderUrl:[" + ConfigurationUtils.getForeignExchangeTransferOrderUrl() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignExchangeTransferOrderUrl(), requestData);
            LOGGER.debug("ForeignExchangeOrderExecuter transferOrderV_3 responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request transferOrderV_3 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void transferQueryV_3(TransferQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("ForeignExchangeOrderExecuter transferQueryV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignExchangeTransferQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.debug("ForeignExchangeOrderExecuter transferQueryV_3 responseStr:[" + responseStr + "]");
            this.transferCallbackV_3(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("ForeignExchangeOrderExecuter transferQueryV_3 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void transferCallbackV_3(JSONObject responseData, ResultListener listener) {
        LOGGER.info("ForeignExchangeOrderExecuter transferCallbackV_3 responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("ForeignExchangeOrderExecuter transferCallbackV_3 data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (ConstantsTransfer.SUCCESS.equals(status)) {
            listener.success(data);
        } else if (ConstantsTransfer.FAILED.equals(status) || ConstantsTransfer.CANCEL.equals(status)) {
            listener.failure(data);
        } else if (ConstantsTransfer.INIT.equals(status) || ConstantsTransfer.PROCESSING.equals(status) || ConstantsTransfer.PAID.equals(status) || ConstantsTransfer.REMITTED.equals(status)) {
            listener.pending(data);
        } else {
            throw new ResponseException(data);
        }
    }
}

