/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.icc.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.icc.v_3.entity.BillInfo;
import com.upay.sdk.icc.v_3.entity.ShipInfo;
import org.apache.commons.lang3.StringUtils;

public class ApiOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String orderAmount;
    private String orderCurrency;
    private String notifyUrl;
    private String terminalNo;
    private String remark;
    private ShipInfo shipInfo;
    private BillInfo billInfo;
    private String firstName;
    private String lastName;
    private String cardNo;
    private String expireM;
    private String expireY;
    private String cardCvv2;
    private String ordip;
    private String partnerId;
    private String projectId;

    public ApiOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public ApiOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public ApiOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ApiOrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public ApiOrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public ApiOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public ApiOrderBuilder setTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
        return this;
    }

    public ApiOrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public ApiOrderBuilder setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public ApiOrderBuilder setShipInfo(ShipInfo shipInfo) {
        this.shipInfo = shipInfo;
        return this;
    }

    public ApiOrderBuilder setBillInfo(BillInfo billInfo) {
        this.billInfo = billInfo;
        return this;
    }

    public ApiOrderBuilder setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public ApiOrderBuilder setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public ApiOrderBuilder setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public ApiOrderBuilder setExpireM(String expireM) {
        this.expireM = expireM;
        return this;
    }

    public ApiOrderBuilder setExpireY(String expireY) {
        this.expireY = expireY;
        return this;
    }

    public ApiOrderBuilder setCardCvv2(String cardCvv2) {
        this.cardCvv2 = cardCvv2;
        return this;
    }

    public ApiOrderBuilder setOrdip(String ordip) {
        this.ordip = ordip;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

