/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.icc.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class PreauthConfirmBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String notifyUrl;
    private String action;
    private String amount;
    private String partnerId;

    public PreauthConfirmBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public PreauthConfirmBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public PreauthConfirmBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public PreauthConfirmBuilder setAction(String action) {
        this.action = action;
        return this;
    }

    public PreauthConfirmBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public PreauthConfirmBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

