/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class NewRetailOrderExtenrGuaranteeBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String orderId;
    private String guaranteeTime;
    private String businessType;

    public NewRetailOrderExtenrGuaranteeBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public NewRetailOrderExtenrGuaranteeBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public NewRetailOrderExtenrGuaranteeBuilder setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public NewRetailOrderExtenrGuaranteeBuilder setGuaranteeTime(String guaranteeTime) {
        this.guaranteeTime = guaranteeTime;
        return this;
    }

    public NewRetailOrderExtenrGuaranteeBuilder setBusinessType(String businessType) {
        this.businessType = businessType;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

