/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.OrderRefundInfo;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public final class NewRetailOrderRefundBuilder
extends BuilderSupport {
    private String merchantId;
    private String amount;
    private String requestId;
    private String notifyUrl;
    private String remark;
    private String clientIp;
    private String orderRequestId;
    private String collectFlag;
    private List<OrderRefundInfo> refundRecords = new LinkedList<OrderRefundInfo>();

    public NewRetailOrderRefundBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public NewRetailOrderRefundBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public NewRetailOrderRefundBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public NewRetailOrderRefundBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public NewRetailOrderRefundBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public NewRetailOrderRefundBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public NewRetailOrderRefundBuilder setOrderRequestId(String orderRequestId) {
        this.orderRequestId = orderRequestId;
        return this;
    }

    public NewRetailOrderRefundBuilder setCollectFlag(String collectFlag) {
        this.collectFlag = collectFlag;
        return this;
    }

    public NewRetailOrderRefundBuilder addRefundRecord(OrderRefundInfo refundRecord) {
        this.refundRecords.add(refundRecord);
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

