/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.OrderSplitInfo;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public class NewRetailSplitBillInfoBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String orderId;
    private List<OrderSplitInfo> splitRecords = new LinkedList<OrderSplitInfo>();
    private String splitBillRule;

    public NewRetailSplitBillInfoBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public NewRetailSplitBillInfoBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public NewRetailSplitBillInfoBuilder setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public NewRetailSplitBillInfoBuilder addSplitRecord(OrderSplitInfo splitRecord) {
        this.splitRecords.add(splitRecord);
        return this;
    }

    public NewRetailSplitBillInfoBuilder setSplitBillRule(String splitBillRule) {
        this.splitBillRule = splitBillRule;
        return this;
    }

    public NewRetailSplitBillInfoBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

