/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class ReportModifyBuilder
extends BuilderSupport {
    private String merchantId;
    private String reportMerchantId;
    private String changeType;
    private String wxT1Fee;
    private String wxT0Fee;
    private String alipayT1Fee;
    private String alipayT0Fee;
    private String bankName;
    private String provinceName;
    private String cityName;
    private String bankBranch;
    private String bankNo;
    private String accountType;
    private String unionBankNo;

    public ReportModifyBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public ReportModifyBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getMerchantCode() {
        return this.reportMerchantId;
    }

    public ReportModifyBuilder setMerchantCode(String merchantCode) {
        this.reportMerchantId = merchantCode;
        return this;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public ReportModifyBuilder setChangeType(String changeType) {
        this.changeType = changeType;
        return this;
    }

    public String getWxT1Fee() {
        return this.wxT1Fee;
    }

    public ReportModifyBuilder setWxT1Fee(String wxT1Fee) {
        this.wxT1Fee = wxT1Fee;
        return this;
    }

    public String getWxT0Fee() {
        return this.wxT0Fee;
    }

    public ReportModifyBuilder setWxT0Fee(String wxT0Fee) {
        this.wxT0Fee = wxT0Fee;
        return this;
    }

    public String getAlipayT1Fee() {
        return this.alipayT1Fee;
    }

    public ReportModifyBuilder setAlipayT1Fee(String alipayT1Fee) {
        this.alipayT1Fee = alipayT1Fee;
        return this;
    }

    public String getAlipayT0Fee() {
        return this.alipayT0Fee;
    }

    public ReportModifyBuilder setAlipayT0Fee(String alipayT0Fee) {
        this.alipayT0Fee = alipayT0Fee;
        return this;
    }

    public String getBankName() {
        return this.bankName;
    }

    public ReportModifyBuilder setBankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public ReportModifyBuilder setProvinceName(String provinceName) {
        this.provinceName = provinceName;
        return this;
    }

    public String getCityName() {
        return this.cityName;
    }

    public ReportModifyBuilder setCityName(String cityName) {
        this.cityName = cityName;
        return this;
    }

    public String getBankBranch() {
        return this.bankBranch;
    }

    public ReportModifyBuilder setBankBranch(String bankBranch) {
        this.bankBranch = bankBranch;
        return this;
    }

    public String getBankNo() {
        return this.bankNo;
    }

    public ReportModifyBuilder setBankNo(String bankNo) {
        this.bankNo = bankNo;
        return this;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public ReportModifyBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public String getUnionBankNo() {
        return this.unionBankNo;
    }

    public ReportModifyBuilder setUnionBankNo(String unionBankNo) {
        this.unionBankNo = unionBankNo;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.merchantId)) {
            json.put("merchantId", (Object)this.merchantId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.reportMerchantId)) {
            json.put("reportMerchantId", (Object)this.reportMerchantId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.changeType)) {
            json.put("changeType", (Object)this.changeType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.wxT1Fee)) {
            json.put("wxT1Fee", (Object)this.wxT1Fee);
        }
        if (StringUtils.isNotBlank((CharSequence)this.wxT0Fee)) {
            json.put("wxT0Fee", (Object)this.wxT0Fee);
        }
        if (StringUtils.isNotBlank((CharSequence)this.alipayT1Fee)) {
            json.put("alipayT1Fee", (Object)this.alipayT1Fee);
        }
        if (StringUtils.isNotBlank((CharSequence)this.alipayT0Fee)) {
            json.put("alipayT0Fee", (Object)this.alipayT0Fee);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankName)) {
            json.put("bankName", (Object)this.bankName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.provinceName)) {
            json.put("provinceName", (Object)this.provinceName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cityName)) {
            json.put("cityName", (Object)this.cityName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankBranch)) {
            json.put("bankBranch", (Object)this.bankBranch);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankNo)) {
            json.put("bankNo", (Object)this.bankNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountType)) {
            json.put("accountType", (Object)this.accountType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.unionBankNo)) {
            json.put("unionBankNo", (Object)this.unionBankNo);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.getMerchantId())).append(StringUtils.defaultString((String)this.reportMerchantId, (String)"")).append(StringUtils.defaultString((String)this.changeType, (String)"")).append((String)ObjectUtils.defaultIfNull((Object)this.wxT1Fee, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.wxT0Fee, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.alipayT1Fee, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.alipayT0Fee, (Object)"")).append(StringUtils.defaultString((String)this.bankName, (String)"")).append(StringUtils.defaultString((String)this.provinceName, (String)"")).append(StringUtils.defaultString((String)this.cityName, (String)"")).append(StringUtils.defaultString((String)this.bankBranch, (String)"")).append(StringUtils.defaultString((String)this.bankNo, (String)"")).append(StringUtils.defaultString((String)this.accountType, (String)"")).append(StringUtils.defaultString((String)this.unionBankNo, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

