/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;

public final class UserQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String username;

    public UserQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public UserQueryBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

