/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.phoenix.v_1.builder.ReportModifyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportModifyExcuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ReportModifyExcuter.class);

    public void modify(ReportModifyBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String reportModifyUrl = ConfigurationUtils.getReportModifyUrl();
                LOGGER.debug("report ModifyUrl:{}", (Object)reportModifyUrl);
                String responseStr = HttpClientUtils.post2(reportModifyUrl, requestData);
                LOGGER.info("responseStr:" + responseStr);
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.decryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.verifyHmacOrder(responseData);
                status = responseData.getString(Constants.STATUS);
                LOGGER.debug("status:[{}]", (Object)status);
                if (Constants.SUCCESS.equals(status)) {
                    LOGGER.debug("invoke success");
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    LOGGER.debug("invoke failure");
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request modify exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

