/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.phoenix.v_1.builder.UserCreateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCreateExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(UserCreateExecuter.class);

    public void userCreate(UserCreateBuilder builder, ResultListener resultListener) {
        if (resultListener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            String phoenixUserCreateUrl = ConfigurationUtils.getPhoenixUserCreateUrl();
            LOGGER.debug("UserCreateExecuter userCreate requestData:[" + requestData.toJSONString() + "],phoenixUserCreateUrl:[" + phoenixUserCreateUrl + "]");
            String responseStr = HttpClientUtils.post2(phoenixUserCreateUrl, requestData);
            LOGGER.debug("UserCreateExecuter userCreate responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.decryptWrap(responseData);
            LOGGER.debug("UserCreateExecuter userCreate  responseData:[" + responseData + "]");
            this.verifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("UserCreateExecuter userCreate exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

