/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.qc.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.qc.builder.OrderBuilder;
import com.upay.sdk.qc.builder.QueryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickRechargeOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(QuickRechargeOrderExecuter.class);

    public void order(OrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getQuickRechargeOrderUrl(), requestData);
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("responseStr:[" + responseData + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
    }

    public void query(QueryBuilder builder, ResultListener resultListener) {
        if (resultListener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getQuickRechargeUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.info("responseStr:[" + responseStr + "]");
            this.callback(responseData, resultListener);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
        }
        catch (Exception e) {
            LOGGER.error("query order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

