/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transfer.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.transfer.ConstantsTransfer;
import com.upay.sdk.transfer.builder.ValidateBuilder;
import com.upay.sdk.transfer.builder.ValidateQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferValidateExecuter
extends Executer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferValidateExecuter.class);

    public void bothValidate(ValidateBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("TransferValidateExecuter bothValidate requestData:[" + requestData.toJSONString() + "],TransferOrderUrl:[" + ConfigurationUtils.getTransferOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferValidateUrl(), requestData);
        LOGGER.debug("TransferValidateExecuter bothValidate responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!ConstantsTransfer.SUCCESS.equals(responseData.getString(ConstantsTransfer.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener transferListener) {
        if (transferListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("TransferValidateExecuter bothCipherCallback data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        String status = data.getString(ConstantsTransfer.STATUS);
        if (ConstantsTransfer.SUCCESS.equals(status)) {
            transferListener.success(data);
        } else if (ConstantsTransfer.FAILED.equals(status) || ConstantsTransfer.CANCEL.equals(status)) {
            transferListener.failure(data);
        } else if (ConstantsTransfer.INIT.equals(status) || ConstantsTransfer.PROCESSING.equals(status) || ConstantsTransfer.PAID.equals(status) || ConstantsTransfer.REMITTED.equals(status)) {
            transferListener.pending(data);
        } else {
            throw new ResponseException(data);
        }
    }

    public void bothValidateQuery(ValidateQueryBuilder builder, ResultListener transferListener) {
        if (transferListener == null) {
            throw new NullPointerException();
        }
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("TransferValidateExecuter bothValidateQuery requestData:[" + requestData.toJSONString() + "],TransferValidateQueryUrl:[" + ConfigurationUtils.getTransferValidateQueryUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferValidateQueryUrl(), requestData);
        LOGGER.debug("TransferValidateExecuter bothValidateQuery responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.bothCipherCallback(responseData, transferListener);
    }
}

