/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transferDomestic.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.transferDomestic.builder.QueryBuilder;
import com.upay.sdk.transferDomestic.builder.SingleOrderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDomesticSingleOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(TransferDomesticSingleOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "amount", "currency", Constants.STATUS, "completeDateTime", "remark"};

    public void order(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "],transferDomesticSingleOrderUrl:[" + ConfigurationUtils.getTransferDomesticSingleOrderUrl() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getTransferDomesticSingleOrderUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(responseData);
            } else if ("REMITING".equals(status)) {
                listener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
    }

    public void query(JSONObject requestData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post(ConfigurationUtils.getTransferDomesticSingleQueryUrl(), requestData.toJSONString());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            this.callback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void order(SingleOrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.encryptBuild();
        LOGGER.debug("TransferDomesticSingleOrderExecuter orderV_2 requestData:[" + requestData.toJSONString() + "],transferDomesticSingleOrderUrl:[" + ConfigurationUtils.getTransferDomesticSingleOrderUrl() + "]");
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getTransferDomesticSingleOrderUrl(), requestData);
        LOGGER.debug("TransferDomesticSingleOrderExecuter orderV_2 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        LOGGER.debug("TransferDomesticSingleOrderExecuter orderV_2 responseStr:[" + responseData + "]");
        this.verifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void query(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("TransferDomesticSingleOrderExecuter queryV_2 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getTransferDomesticSingleQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("TransferDomesticSingleOrderExecuter queryV_2 decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("TransferDomesticSingleOrderExecuter queryV_2 responseStr:[" + responseStr + "]");
            this.cipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void cipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if ("REMITING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void bothOrder(SingleOrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("TransferDomesticSingleOrderExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],transferDomesticSingleOrderUrl:[" + ConfigurationUtils.getTransferDomesticSingleOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferDomesticSingleOrderUrl(), requestData);
        LOGGER.debug("TransferDomesticSingleOrderExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("TransferDomesticSingleOrderExecuter orderV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothQuery(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("TransferDomesticSingleOrderExecuter queryV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferDomesticSingleQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("TransferDomesticSingleOrderExecuter queryV_3 decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("TransferDomesticSingleOrderExecuter queryV_3 responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if ("REMITING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

