/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class MerchantRechargeBatchBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String walletId;
    private String amount;
    private String currency;
    private String notifyUrl;
    private String remark;

    public MerchantRechargeBatchBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public MerchantRechargeBatchBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MerchantRechargeBatchBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public MerchantRechargeBatchBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public MerchantRechargeBatchBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public MerchantRechargeBatchBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public MerchantRechargeBatchBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public MerchantRechargeBatchBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

