/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class RedPacketBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String walletId;
    private String targetWalletId;
    private String amount;
    private String singleAmount;
    private String currency;
    private String packetType;
    private String packetCount;
    private String notifyUrl;
    private String timeout;
    private String remark;

    public RedPacketBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RedPacketBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public RedPacketBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RedPacketBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public RedPacketBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public RedPacketBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public RedPacketBuilder setSingleAmount(String singleAmount) {
        this.singleAmount = singleAmount;
        return this;
    }

    public RedPacketBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public RedPacketBuilder setTargetWalletId(String targetWalletId) {
        this.targetWalletId = targetWalletId;
        return this;
    }

    public RedPacketBuilder setPacketType(String packetType) {
        this.packetType = packetType;
        return this;
    }

    public RedPacketBuilder setPacketCount(String packetCount) {
        this.packetCount = packetCount;
        return this;
    }

    public RedPacketBuilder setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public RedPacketBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

