/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class TradeRecordBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String walletId;
    private String pageIndex;
    private String pageSize;
    private String startDateTime;
    private String endDateTime;
    private String tradeType;
    private String direction;
    private String tradeSubType;

    public TradeRecordBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public TradeRecordBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public TradeRecordBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public TradeRecordBuilder setPageIndex(String pageIndex) {
        this.pageIndex = pageIndex;
        return this;
    }

    public TradeRecordBuilder setStartDateTime(String startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public TradeRecordBuilder setEndDateTime(String endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    public TradeRecordBuilder setTradeType(String tradeType) {
        this.tradeType = tradeType;
        return this;
    }

    public TradeRecordBuilder setTradeSubType(String tradeSubType) {
        this.tradeSubType = tradeSubType;
        return this;
    }

    public TradeRecordBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public TradeRecordBuilder setPageSize(String pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public TradeRecordBuilder setDirection(String direction) {
        this.direction = direction;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

