/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public class WalletCreateBuilder
extends BuilderSupport {
    private String requestId;
    private String merchantId;
    private String merchantUserId;
    private String name;
    private String idCardType;
    private String idCardNo;
    private String mobile;
    private String profession;
    private String ip;
    private String mac;
    private String nickName;

    public WalletCreateBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public WalletCreateBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public WalletCreateBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WalletCreateBuilder setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
        return this;
    }

    public WalletCreateBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public WalletCreateBuilder setIdCardType(String idCardType) {
        this.idCardType = idCardType;
        return this;
    }

    public WalletCreateBuilder setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
        return this;
    }

    public WalletCreateBuilder setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public WalletCreateBuilder setProfession(String profession) {
        this.profession = profession;
        return this;
    }

    public WalletCreateBuilder setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public WalletCreateBuilder setMac(String mac) {
        this.mac = mac;
        return this;
    }

    public WalletCreateBuilder setNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

