/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.executer.ResultListenerAdpater;
import com.upay.sdk.webox.builder.TransferConfirmBuilder;
import com.upay.sdk.webox.builder.TransferCreateBuilder;
import com.upay.sdk.webox.builder.TransferQueryBuilder;
import com.upay.sdk.webox.builder.TransferRefuseBuilder;
import com.upay.sdk.webox.builder.TransferTimeoutReturnBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferExecuter
extends Executer {
    final Logger LOGGER = LoggerFactory.getLogger(TransferExecuter.class);

    public void bothCreate(TransferCreateBuilder builder, ResultListener resultListener) {
        block7: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                this.LOGGER.debug("transfer requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTransferCreateUrl(), requestData);
                this.LOGGER.info("transfer responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                this.LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block7;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block7;
                }
                if (Constants.REDIRECT.equals(status)) {
                    resultListener.redirect(responseData, responseData.getString("payUrl"));
                    break block7;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                this.LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothConfirm(TransferConfirmBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                this.LOGGER.debug("transfer requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTransferConfirmUrl(), requestData);
                this.LOGGER.info("transfer responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                this.LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                this.LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothRefuse(TransferRefuseBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                this.LOGGER.debug("transfer requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTransferRefuseUrl(), requestData);
                this.LOGGER.info("transfer responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                this.LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                this.LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothQuery(TransferQueryBuilder builder, ResultListenerAdpater resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                this.LOGGER.debug("transfer requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTransferQueryUrl(), requestData);
                this.LOGGER.info("transfer responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                this.LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                this.LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothTimeoutReturn(TransferTimeoutReturnBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                this.LOGGER.debug("transfer requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxTransferTimeoutReturnUrl(), requestData);
                this.LOGGER.info("transfer responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                this.LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                this.LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

