/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.executer.ResultListenerAdpater;
import com.upay.sdk.webox.builder.OnlinePayCreateBuilder;
import com.upay.sdk.webox.builder.OnlinePayQueryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeboxOnlinePayOrderExecuter
extends Executer {
    final Logger LOGGER = LoggerFactory.getLogger(WeboxOnlinePayOrderExecuter.class);

    public void bothCreate(OnlinePayCreateBuilder builder, ResultListener resultListener) {
        block7: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                this.LOGGER.debug("weboxOnlinePay requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxOnlinePayCreateUrl(), requestData);
                this.LOGGER.info("weboxOnlinePay responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                this.LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block7;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block7;
                }
                if (Constants.REDIRECT.equals(status)) {
                    resultListener.redirect(responseData, responseData.getString("payUrl"));
                    break block7;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                this.LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothQuery(OnlinePayQueryBuilder builder, ResultListenerAdpater resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                this.LOGGER.debug("weboxOnlinePay requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxOnlinePayQueryUrl(), requestData);
                this.LOGGER.info("weboxOnlinePay responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                this.LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                this.LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

