/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.withholding.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderBuilderBatch
extends BuilderSupport {
    static final Logger LOGGER = LoggerFactory.getLogger(OrderBuilderBatch.class);
    private String language = "zh_CN";
    private String requestId;
    private String merchantId;
    private String feeBear;
    private String currency;
    private String detailPath;
    private String notifyUrl;
    private String userIp;

    public OrderBuilderBatch(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilderBatch setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilderBatch setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OrderBuilderBatch setFeeBear(String feeBear) {
        this.feeBear = feeBear;
        return this;
    }

    public OrderBuilderBatch setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public OrderBuilderBatch setDetailPath(String detailPath) {
        this.detailPath = detailPath;
        return this;
    }

    public OrderBuilderBatch setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilderBatch setLanguage(String language) {
        this.language = language;
        return this;
    }

    public OrderBuilderBatch setUserIp(String userIp) {
        this.userIp = userIp;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.feeBear)) {
            json.put("feeBear", (Object)this.feeBear);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.detailPath)) {
            json.put("detailPath", (Object)this.detailPath);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userIp)) {
            json.put("userIp", (Object)this.userIp);
        }
        if (StringUtils.isNotBlank((CharSequence)this.language)) {
            json.put("language", (Object)this.language);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.feeBear)).append(StringUtils.defaultString((String)this.currency)).append(StringUtils.defaultString((String)this.detailPath)).append(StringUtils.defaultString((String)this.userIp)).append(StringUtils.defaultString((String)this.language)).append(StringUtils.defaultString((String)this.notifyUrl));
        LOGGER.info("hmacSource:" + hmacSource + "key:" + ConfigurationUtils.getHmacKey(this.merchantId));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

