/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.by_1_52.asn1.ASN1EncodableVector;
import org.bouncycastle.by_1_52.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.by_1_52.asn1.ASN1Primitive;
import org.bouncycastle.by_1_52.asn1.ASN1Sequence;
import org.bouncycastle.by_1_52.asn1.DERSequence;
import org.bouncycastle.by_1_52.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.by_1_52.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.by_1_52.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.by_1_52.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.by_1_52.asn1.x509.AlgorithmIdentifier;

public class PBES2Algorithms
extends AlgorithmIdentifier
implements PKCSObjectIdentifiers {
    private ASN1ObjectIdentifier objectId;
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public PBES2Algorithms(ASN1Sequence obj) {
        super(obj);
        Enumeration e = obj.getObjects();
        this.objectId = (ASN1ObjectIdentifier)e.nextElement();
        ASN1Sequence seq = (ASN1Sequence)e.nextElement();
        e = seq.getObjects();
        ASN1Sequence funcSeq = (ASN1Sequence)e.nextElement();
        this.func = funcSeq.getObjectAt(0).equals(id_PBKDF2) ? new KeyDerivationFunc(id_PBKDF2, PBKDF2Params.getInstance(funcSeq.getObjectAt(1))) : KeyDerivationFunc.getInstance(funcSeq);
        this.scheme = EncryptionScheme.getInstance(e.nextElement());
    }

    @Override
    public ASN1ObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    public ASN1Primitive getASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        ASN1EncodableVector subV = new ASN1EncodableVector();
        v.add(this.objectId);
        subV.add(this.func);
        subV.add(this.scheme);
        v.add(new DERSequence(subV));
        return new DERSequence(v);
    }
}

