/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.ec;

import org.bouncycastle.by_1_52.crypto.CipherParameters;
import org.bouncycastle.by_1_52.crypto.ec.ECDecryptor;
import org.bouncycastle.by_1_52.crypto.ec.ECPair;
import org.bouncycastle.by_1_52.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.by_1_52.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)param;
    }

    @Override
    public ECPoint decrypt(ECPair pair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECPoint tmp = pair.getX().multiply(this.key.getD());
        return pair.getY().subtract(tmp).normalize();
    }
}

