/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.by_1_52.crypto.tls.DTLSHandshakeRetransmit;
import org.bouncycastle.by_1_52.crypto.tls.DTLSReassembler;
import org.bouncycastle.by_1_52.crypto.tls.DTLSRecordLayer;
import org.bouncycastle.by_1_52.crypto.tls.DeferredHash;
import org.bouncycastle.by_1_52.crypto.tls.TlsContext;
import org.bouncycastle.by_1_52.crypto.tls.TlsFatalAlert;
import org.bouncycastle.by_1_52.crypto.tls.TlsHandshakeHash;
import org.bouncycastle.by_1_52.crypto.tls.TlsUtils;
import org.bouncycastle.by_1_52.util.Integers;

class DTLSReliableHandshake {
    private static final int MAX_RECEIVE_AHEAD = 10;
    private final DTLSRecordLayer recordLayer;
    private TlsHandshakeHash handshakeHash;
    private Hashtable currentInboundFlight = new Hashtable();
    private Hashtable previousInboundFlight = null;
    private Vector outboundFlight = new Vector();
    private boolean sending = true;
    private int message_seq = 0;
    private int next_receive_seq = 0;

    DTLSReliableHandshake(TlsContext context, DTLSRecordLayer transport) {
        this.recordLayer = transport;
        this.handshakeHash = new DeferredHash();
        this.handshakeHash.init(context);
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash result = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return result;
    }

    void sendMessage(short msg_type, byte[] body) throws IOException {
        TlsUtils.checkUint24(body.length);
        if (!this.sending) {
            this.checkInboundFlight();
            this.sending = true;
            this.outboundFlight.removeAllElements();
        }
        Message message = new Message(this.message_seq++, msg_type, body);
        this.outboundFlight.addElement(message);
        this.writeMessage(message);
        this.updateHandshakeMessagesDigest(message);
    }

    byte[] receiveMessageBody(short msg_type) throws IOException {
        Message message = this.receiveMessage();
        if (message.getType() != msg_type) {
            throw new TlsFatalAlert(10);
        }
        return message.getBody();
    }

    Message receiveMessage() throws IOException {
        byte[] body;
        DTLSReassembler next;
        if (this.sending) {
            this.sending = false;
            this.prepareInboundFlight();
        }
        if ((next = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(this.next_receive_seq))) != null && (body = next.getBodyIfComplete()) != null) {
            this.previousInboundFlight = null;
            return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, next.getMsgType(), body));
        }
        byte[] buf = null;
        int readTimeoutMillis = 1000;
        while (true) {
            int receiveLimit = this.recordLayer.getReceiveLimit();
            if (buf == null || buf.length < receiveLimit) {
                buf = new byte[receiveLimit];
            }
            try {
                int received;
                while ((received = this.recordLayer.receive(buf, 0, receiveLimit, readTimeoutMillis)) >= 0) {
                    byte[] body2;
                    DTLSReassembler reassembler;
                    int seq;
                    int fragment_length;
                    if (received < 12 || received != (fragment_length = TlsUtils.readUint24(buf, 9)) + 12 || (seq = TlsUtils.readUint16(buf, 4)) > this.next_receive_seq + 10) continue;
                    short msg_type = TlsUtils.readUint8(buf, 0);
                    int length = TlsUtils.readUint24(buf, 1);
                    int fragment_offset = TlsUtils.readUint24(buf, 6);
                    if (fragment_offset + fragment_length > length) continue;
                    if (seq < this.next_receive_seq) {
                        if (this.previousInboundFlight == null || (reassembler = (DTLSReassembler)this.previousInboundFlight.get(Integers.valueOf(seq))) == null) continue;
                        reassembler.contributeFragment(msg_type, length, buf, 12, fragment_offset, fragment_length);
                        if (!DTLSReliableHandshake.checkAll(this.previousInboundFlight)) continue;
                        this.resendOutboundFlight();
                        readTimeoutMillis = Math.min(readTimeoutMillis * 2, 60000);
                        DTLSReliableHandshake.resetAll(this.previousInboundFlight);
                        continue;
                    }
                    reassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(seq));
                    if (reassembler == null) {
                        reassembler = new DTLSReassembler(msg_type, length);
                        this.currentInboundFlight.put(Integers.valueOf(seq), reassembler);
                    }
                    reassembler.contributeFragment(msg_type, length, buf, 12, fragment_offset, fragment_length);
                    if (seq != this.next_receive_seq || (body2 = reassembler.getBodyIfComplete()) == null) continue;
                    this.previousInboundFlight = null;
                    return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, reassembler.getMsgType(), body2));
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.resendOutboundFlight();
            readTimeoutMillis = Math.min(readTimeoutMillis * 2, 60000);
        }
    }

    void finish() {
        DTLSHandshakeRetransmit retransmit = null;
        if (!this.sending) {
            this.checkInboundFlight();
        } else if (this.currentInboundFlight != null) {
            retransmit = new DTLSHandshakeRetransmit(){

                @Override
                public void receivedHandshakeRecord(int epoch, byte[] buf, int off, int len) throws IOException {
                    int expectedEpoch;
                    if (len < 12) {
                        return;
                    }
                    int fragment_length = TlsUtils.readUint24(buf, off + 9);
                    if (len != fragment_length + 12) {
                        return;
                    }
                    int seq = TlsUtils.readUint16(buf, off + 4);
                    if (seq >= DTLSReliableHandshake.this.next_receive_seq) {
                        return;
                    }
                    short msg_type = TlsUtils.readUint8(buf, off);
                    int n = expectedEpoch = msg_type == 20 ? 1 : 0;
                    if (epoch != expectedEpoch) {
                        return;
                    }
                    int length = TlsUtils.readUint24(buf, off + 1);
                    int fragment_offset = TlsUtils.readUint24(buf, off + 6);
                    if (fragment_offset + fragment_length > length) {
                        return;
                    }
                    DTLSReassembler reassembler = (DTLSReassembler)DTLSReliableHandshake.this.currentInboundFlight.get(Integers.valueOf(seq));
                    if (reassembler != null) {
                        reassembler.contributeFragment(msg_type, length, buf, off + 12, fragment_offset, fragment_length);
                        if (DTLSReliableHandshake.checkAll(DTLSReliableHandshake.this.currentInboundFlight)) {
                            DTLSReliableHandshake.this.resendOutboundFlight();
                            DTLSReliableHandshake.resetAll(DTLSReliableHandshake.this.currentInboundFlight);
                        }
                    }
                }
            };
        }
        this.recordLayer.handshakeSuccessful(retransmit);
    }

    void resetHandshakeMessagesDigest() {
        this.handshakeHash.reset();
    }

    private void checkInboundFlight() {
        Enumeration e = this.currentInboundFlight.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            if (key < this.next_receive_seq) continue;
        }
    }

    private void prepareInboundFlight() {
        DTLSReliableHandshake.resetAll(this.currentInboundFlight);
        this.previousInboundFlight = this.currentInboundFlight;
        this.currentInboundFlight = new Hashtable();
    }

    private void resendOutboundFlight() throws IOException {
        this.recordLayer.resetWriteEpoch();
        for (int i = 0; i < this.outboundFlight.size(); ++i) {
            this.writeMessage((Message)this.outboundFlight.elementAt(i));
        }
    }

    private Message updateHandshakeMessagesDigest(Message message) throws IOException {
        if (message.getType() != 0) {
            byte[] body = message.getBody();
            byte[] buf = new byte[12];
            TlsUtils.writeUint8(message.getType(), buf, 0);
            TlsUtils.writeUint24(body.length, buf, 1);
            TlsUtils.writeUint16(message.getSeq(), buf, 4);
            TlsUtils.writeUint24(0, buf, 6);
            TlsUtils.writeUint24(body.length, buf, 9);
            this.handshakeHash.update(buf, 0, buf.length);
            this.handshakeHash.update(body, 0, body.length);
        }
        return message;
    }

    private void writeMessage(Message message) throws IOException {
        int fragment_length;
        int sendLimit = this.recordLayer.getSendLimit();
        int fragmentLimit = sendLimit - 12;
        if (fragmentLimit < 1) {
            throw new TlsFatalAlert(80);
        }
        int length = message.getBody().length;
        int fragment_offset = 0;
        do {
            fragment_length = Math.min(length - fragment_offset, fragmentLimit);
            this.writeHandshakeFragment(message, fragment_offset, fragment_length);
        } while ((fragment_offset += fragment_length) < length);
    }

    private void writeHandshakeFragment(Message message, int fragment_offset, int fragment_length) throws IOException {
        RecordLayerBuffer fragment = new RecordLayerBuffer(12 + fragment_length);
        TlsUtils.writeUint8(message.getType(), (OutputStream)fragment);
        TlsUtils.writeUint24(message.getBody().length, fragment);
        TlsUtils.writeUint16(message.getSeq(), fragment);
        TlsUtils.writeUint24(fragment_offset, fragment);
        TlsUtils.writeUint24(fragment_length, fragment);
        fragment.write(message.getBody(), fragment_offset, fragment_length);
        fragment.sendToRecordLayer(this.recordLayer);
    }

    private static boolean checkAll(Hashtable inboundFlight) {
        Enumeration e = inboundFlight.elements();
        while (e.hasMoreElements()) {
            if (((DTLSReassembler)e.nextElement()).getBodyIfComplete() != null) continue;
            return false;
        }
        return true;
    }

    private static void resetAll(Hashtable inboundFlight) {
        Enumeration e = inboundFlight.elements();
        while (e.hasMoreElements()) {
            ((DTLSReassembler)e.nextElement()).reset();
        }
    }

    static class RecordLayerBuffer
    extends ByteArrayOutputStream {
        RecordLayerBuffer(int size) {
            super(size);
        }

        void sendToRecordLayer(DTLSRecordLayer recordLayer) throws IOException {
            recordLayer.send(this.buf, 0, this.count);
            this.buf = null;
        }
    }

    static class Message {
        private final int message_seq;
        private final short msg_type;
        private final byte[] body;

        private Message(int message_seq, short msg_type, byte[] body) {
            this.message_seq = message_seq;
            this.msg_type = msg_type;
            this.body = body;
        }

        public int getSeq() {
            return this.message_seq;
        }

        public short getType() {
            return this.msg_type;
        }

        public byte[] getBody() {
            return this.body;
        }
    }
}

