/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.jcajce.provider.asymmetric.dsa;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import org.bouncycastle.by_1_52.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.by_1_52.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.by_1_52.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.by_1_52.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.by_1_52.crypto.params.DSAParameters;
import org.bouncycastle.by_1_52.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.by_1_52.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.by_1_52.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey;
import org.bouncycastle.by_1_52.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    DSAKeyGenerationParameters param;
    DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
    int strength = 1024;
    int certainty = 20;
    SecureRandom random = new SecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DSA");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        if (strength < 512 || strength > 4096 || strength < 1024 && strength % 64 != 0 || strength >= 1024 && strength % 1024 != 0) {
            throw new InvalidParameterException("strength must be from 512 - 4096 and a multiple of 1024 above 1024");
        }
        this.strength = strength;
        this.random = random;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
        }
        DSAParameterSpec dsaParams = (DSAParameterSpec)params;
        this.param = new DSAKeyGenerationParameters(random, new DSAParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            DSAParametersGenerator pGen = new DSAParametersGenerator();
            pGen.init(this.strength, this.certainty, this.random);
            this.param = new DSAKeyGenerationParameters(this.random, pGen.generateParameters());
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        DSAPublicKeyParameters pub = (DSAPublicKeyParameters)pair.getPublic();
        DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCDSAPublicKey(pub), new BCDSAPrivateKey(priv));
    }
}

