/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.jcajce.provider.asymmetric.util;

import org.bouncycastle.by_1_52.asn1.ASN1Encodable;
import org.bouncycastle.by_1_52.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.by_1_52.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.by_1_52.asn1.x509.SubjectPublicKeyInfo;

public class KeyUtil {
    public static byte[] getEncodedSubjectPublicKeyInfo(AlgorithmIdentifier algId, ASN1Encodable keyData) {
        try {
            return KeyUtil.getEncodedSubjectPublicKeyInfo(new SubjectPublicKeyInfo(algId, keyData));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] getEncodedSubjectPublicKeyInfo(AlgorithmIdentifier algId, byte[] keyData) {
        try {
            return KeyUtil.getEncodedSubjectPublicKeyInfo(new SubjectPublicKeyInfo(algId, keyData));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] getEncodedSubjectPublicKeyInfo(SubjectPublicKeyInfo info) {
        try {
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] getEncodedPrivateKeyInfo(AlgorithmIdentifier algId, ASN1Encodable privKey) {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(algId, privKey.toASN1Primitive());
            return KeyUtil.getEncodedPrivateKeyInfo(info);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] getEncodedPrivateKeyInfo(PrivateKeyInfo info) {
        try {
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            return null;
        }
    }
}

