/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.jce;

import java.util.Enumeration;
import org.bouncycastle.by_1_52.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.by_1_52.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.by_1_52.crypto.params.ECDomainParameters;
import org.bouncycastle.by_1_52.jce.spec.ECNamedCurveParameterSpec;

public class ECGOST3410NamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        ECDomainParameters ecP = ECGOST3410NamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = ECGOST3410NamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        return ECGOST3410NamedCurves.getNames();
    }
}

