/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.by_1_52.math.ec.ECCurve;
import org.bouncycastle.by_1_52.math.ec.ECFieldElement;
import org.bouncycastle.by_1_52.math.ec.ECPoint;
import org.bouncycastle.by_1_52.math.ec.custom.sec.SecP192R1FieldElement;
import org.bouncycastle.by_1_52.math.ec.custom.sec.SecP192R1Point;
import org.bouncycastle.by_1_52.util.encoders.Hex;

public class SecP192R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF"));
    private static final int SecP192R1_DEFAULT_COORDS = 2;
    protected SecP192R1Point infinity = new SecP192R1Point(this, null, null);

    public SecP192R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP192R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecP192R1FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecP192R1Point((ECCurve)this, x, y, withCompression);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecP192R1Point(this, x, y, zs, withCompression);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }
}

