/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.pqc.crypto.gmss;

import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.by_1_52.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.by_1_52.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.by_1_52.crypto.Digest;
import org.bouncycastle.by_1_52.crypto.KeyGenerationParameters;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.GMSSDigestProvider;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.GMSSKeyGenerationParameters;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.GMSSParameters;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.GMSSPublicKeyParameters;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.GMSSRootCalc;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.Treehash;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.util.GMSSRandom;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.util.WinternitzOTSVerify;
import org.bouncycastle.by_1_52.pqc.crypto.gmss.util.WinternitzOTSignature;

public class GMSSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private GMSSRandom gmssRandom;
    private Digest messDigestTree;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][] currentRootSigs;
    private GMSSDigestProvider digestProvider;
    private int mdLength;
    private int numLayer;
    private boolean initialized = false;
    private GMSSParameters gmssPS;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private GMSSKeyGenerationParameters gmssParams;
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.3";

    public GMSSKeyPairGenerator(GMSSDigestProvider digestProvider) {
        this.digestProvider = digestProvider;
        this.messDigestTree = digestProvider.get();
        this.mdLength = this.messDigestTree.getDigestSize();
        this.gmssRandom = new GMSSRandom(this.messDigestTree);
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        int i;
        GMSSRootCalc tree;
        int h;
        if (!this.initialized) {
            this.initializeDefault();
        }
        byte[][][] currentAuthPaths = new byte[this.numLayer][][];
        byte[][][] nextAuthPaths = new byte[this.numLayer - 1][][];
        Treehash[][] currentTreehash = new Treehash[this.numLayer][];
        Treehash[][] nextTreehash = new Treehash[this.numLayer - 1][];
        Vector[] currentStack = new Vector[this.numLayer];
        Vector[] nextStack = new Vector[this.numLayer - 1];
        Vector[][] currentRetain = new Vector[this.numLayer][];
        Vector[][] nextRetain = new Vector[this.numLayer - 1][];
        for (int i2 = 0; i2 < this.numLayer; ++i2) {
            currentAuthPaths[i2] = new byte[this.heightOfTrees[i2]][this.mdLength];
            currentTreehash[i2] = new Treehash[this.heightOfTrees[i2] - this.K[i2]];
            if (i2 > 0) {
                nextAuthPaths[i2 - 1] = new byte[this.heightOfTrees[i2]][this.mdLength];
                nextTreehash[i2 - 1] = new Treehash[this.heightOfTrees[i2] - this.K[i2]];
            }
            currentStack[i2] = new Vector();
            if (i2 <= 0) continue;
            nextStack[i2 - 1] = new Vector();
        }
        byte[][] currentRoots = new byte[this.numLayer][this.mdLength];
        byte[][] nextRoots = new byte[this.numLayer - 1][this.mdLength];
        byte[][] seeds = new byte[this.numLayer][this.mdLength];
        for (int i3 = 0; i3 < this.numLayer; ++i3) {
            System.arraycopy(this.currentSeeds[i3], 0, seeds[i3], 0, this.mdLength);
        }
        this.currentRootSigs = new byte[this.numLayer - 1][this.mdLength];
        for (h = this.numLayer - 1; h >= 0; --h) {
            tree = new GMSSRootCalc(this.heightOfTrees[h], this.K[h], this.digestProvider);
            try {
                tree = h == this.numLayer - 1 ? this.generateCurrentAuthpathAndRoot(null, currentStack[h], seeds[h], h) : this.generateCurrentAuthpathAndRoot(currentRoots[h + 1], currentStack[h], seeds[h], h);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            for (i = 0; i < this.heightOfTrees[h]; ++i) {
                System.arraycopy(tree.getAuthPath()[i], 0, currentAuthPaths[h][i], 0, this.mdLength);
            }
            currentRetain[h] = tree.getRetain();
            currentTreehash[h] = tree.getTreehash();
            System.arraycopy(tree.getRoot(), 0, currentRoots[h], 0, this.mdLength);
        }
        for (h = this.numLayer - 2; h >= 0; --h) {
            tree = this.generateNextAuthpathAndRoot(nextStack[h], seeds[h + 1], h + 1);
            for (i = 0; i < this.heightOfTrees[h + 1]; ++i) {
                System.arraycopy(tree.getAuthPath()[i], 0, nextAuthPaths[h][i], 0, this.mdLength);
            }
            nextRetain[h] = tree.getRetain();
            nextTreehash[h] = tree.getTreehash();
            System.arraycopy(tree.getRoot(), 0, nextRoots[h], 0, this.mdLength);
            System.arraycopy(seeds[h + 1], 0, this.nextNextSeeds[h], 0, this.mdLength);
        }
        GMSSPublicKeyParameters publicKey = new GMSSPublicKeyParameters(currentRoots[0], this.gmssPS);
        GMSSPrivateKeyParameters privateKey = new GMSSPrivateKeyParameters(this.currentSeeds, this.nextNextSeeds, currentAuthPaths, nextAuthPaths, currentTreehash, nextTreehash, currentStack, nextStack, currentRetain, nextRetain, nextRoots, this.currentRootSigs, this.gmssPS, this.digestProvider);
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }

    private GMSSRootCalc generateCurrentAuthpathAndRoot(byte[] lowerRoot, Vector currentStack, byte[] seed, int h) {
        WinternitzOTSignature ots;
        byte[] help = new byte[this.mdLength];
        byte[] OTSseed = new byte[this.mdLength];
        OTSseed = this.gmssRandom.nextSeed(seed);
        GMSSRootCalc treeToConstruct = new GMSSRootCalc(this.heightOfTrees[h], this.K[h], this.digestProvider);
        treeToConstruct.initialize(currentStack);
        if (h == this.numLayer - 1) {
            ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[h]);
            help = ots.getPublicKey();
        } else {
            ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[h]);
            this.currentRootSigs[h] = ots.getSignature(lowerRoot);
            WinternitzOTSVerify otsver = new WinternitzOTSVerify(this.digestProvider.get(), this.otsIndex[h]);
            help = otsver.Verify(lowerRoot, this.currentRootSigs[h]);
        }
        treeToConstruct.update(help);
        int seedForTreehashIndex = 3;
        int count = 0;
        for (int i = 1; i < 1 << this.heightOfTrees[h]; ++i) {
            if (i == seedForTreehashIndex && count < this.heightOfTrees[h] - this.K[h]) {
                treeToConstruct.initializeTreehashSeed(seed, count);
                seedForTreehashIndex *= 2;
                ++count;
            }
            OTSseed = this.gmssRandom.nextSeed(seed);
            ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[h]);
            treeToConstruct.update(ots.getPublicKey());
        }
        if (treeToConstruct.wasFinished()) {
            return treeToConstruct;
        }
        System.err.println("Baum noch nicht fertig konstruiert!!!");
        return null;
    }

    private GMSSRootCalc generateNextAuthpathAndRoot(Vector nextStack, byte[] seed, int h) {
        byte[] OTSseed = new byte[this.numLayer];
        GMSSRootCalc treeToConstruct = new GMSSRootCalc(this.heightOfTrees[h], this.K[h], this.digestProvider);
        treeToConstruct.initialize(nextStack);
        int seedForTreehashIndex = 3;
        int count = 0;
        for (int i = 0; i < 1 << this.heightOfTrees[h]; ++i) {
            if (i == seedForTreehashIndex && count < this.heightOfTrees[h] - this.K[h]) {
                treeToConstruct.initializeTreehashSeed(seed, count);
                seedForTreehashIndex *= 2;
                ++count;
            }
            OTSseed = this.gmssRandom.nextSeed(seed);
            WinternitzOTSignature ots = new WinternitzOTSignature(OTSseed, this.digestProvider.get(), this.otsIndex[h]);
            treeToConstruct.update(ots.getPublicKey());
        }
        if (treeToConstruct.wasFinished()) {
            return treeToConstruct;
        }
        System.err.println("N\ufffdchster Baum noch nicht fertig konstruiert!!!");
        return null;
    }

    public void initialize(int keySize, SecureRandom secureRandom) {
        GMSSKeyGenerationParameters kgp;
        if (keySize <= 10) {
            int[] defh = new int[]{10};
            int[] defw = new int[]{3};
            int[] defk = new int[]{2};
            kgp = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(defh.length, defh, defw, defk));
        } else if (keySize <= 20) {
            int[] defh = new int[]{10, 10};
            int[] defw = new int[]{5, 4};
            int[] defk = new int[]{2, 2};
            kgp = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(defh.length, defh, defw, defk));
        } else {
            int[] defh = new int[]{10, 10, 10, 10};
            int[] defw = new int[]{9, 9, 9, 3};
            int[] defk = new int[]{2, 2, 2, 2};
            kgp = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(defh.length, defh, defw, defk));
        }
        this.initialize(kgp);
    }

    public void initialize(KeyGenerationParameters param) {
        this.gmssParams = (GMSSKeyGenerationParameters)param;
        this.gmssPS = new GMSSParameters(this.gmssParams.getParameters().getNumOfLayers(), this.gmssParams.getParameters().getHeightOfTrees(), this.gmssParams.getParameters().getWinternitzParameter(), this.gmssParams.getParameters().getK());
        this.numLayer = this.gmssPS.getNumOfLayers();
        this.heightOfTrees = this.gmssPS.getHeightOfTrees();
        this.otsIndex = this.gmssPS.getWinternitzParameter();
        this.K = this.gmssPS.getK();
        this.currentSeeds = new byte[this.numLayer][this.mdLength];
        this.nextNextSeeds = new byte[this.numLayer - 1][this.mdLength];
        SecureRandom secRan = new SecureRandom();
        for (int i = 0; i < this.numLayer; ++i) {
            secRan.nextBytes(this.currentSeeds[i]);
            this.gmssRandom.nextSeed(this.currentSeeds[i]);
        }
        this.initialized = true;
    }

    private void initializeDefault() {
        int[] defh = new int[]{10, 10, 10, 10};
        int[] defw = new int[]{3, 3, 3, 3};
        int[] defk = new int[]{2, 2, 2, 2};
        GMSSKeyGenerationParameters kgp = new GMSSKeyGenerationParameters(new SecureRandom(), new GMSSParameters(defh.length, defh, defw, defk));
        this.initialize(kgp);
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

