/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class OSInfo {
    public static OSName getOSName() {
        String val = System.getProperty("os.name");
        if (val != null) {
            if ((val = val.toLowerCase()).contains("linux")) {
                return OSName.linux;
            }
            if (val.contains("windows")) {
                return OSName.windows;
            }
            if (val.contains("mac")) {
                return OSName.mac;
            }
        }
        return OSName.unknown;
    }

    public static OSArch getJVMArch() {
        String val = System.getProperty("os.arch");
        if (val != null) {
            if ((val = val.toLowerCase()).contains("86_64") || val.contains("amd64")) {
                return OSArch.x86_64;
            }
            if (val.contains("86")) {
                return OSArch.x86;
            }
        }
        return OSArch.unknown;
    }

    public static String getTempDirectory() {
        return OSInfo.extractDirectory(System.getProperty("java.io.tmpdir"));
    }

    public static String getExecutableTempDirectory() {
        String result = OSInfo.getTempDirectory();
        if (OSInfo.getOSName() == OSName.linux) {
            try {
                if (!OSInfo.isExecutableTemp(result)) {
                    String homeTemp = OSInfo.getUserHomeDirectory() + File.separator + "tmp";
                    File newTemp = new File(homeTemp);
                    if (!newTemp.exists()) {
                        newTemp.mkdirs();
                    }
                    if (newTemp.exists()) {
                        result = homeTemp;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getUserHomeDirectory() {
        return OSInfo.extractDirectory(System.getProperty("user.home"));
    }

    protected static String extractDirectory(String val) {
        String string = val = val != null ? val : "";
        if (val.endsWith(File.separator)) {
            val = val.substring(0, val.length() - 1);
        }
        return val;
    }

    protected static boolean isExecutableTemp(String tempDir) {
        if (tempDir != null && tempDir.trim().length() > 0) {
            try {
                String line;
                Process p = Runtime.getRuntime().exec("mount");
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String match = "(.*)" + tempDir + "(.*)noexec(.*)";
                while ((line = in.readLine()) != null) {
                    if (!line.matches(match)) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static enum OSArch {
        unknown,
        x86_64,
        x86;

    }

    public static enum OSName {
        unknown(""),
        windows(".dll"),
        linux(".so"),
        mac(".dylib");

        private String extension;

        private OSName(String inExtension) {
            this.extension = inExtension;
        }

        public String getLibExtension() {
            return this.extension;
        }
    }
}

