/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg.processor.api;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ImageProcessInfo {
    protected final Map<String, Object> map;

    private ImageProcessInfo(Map<String, Object> inMap) {
        if (inMap == null) {
            throw new IllegalArgumentException("Input map can't be null");
        }
        this.map = inMap;
    }

    public int getInputWidth() {
        return (Integer)this.getValue(ProcessKey.INPUT_WIDTH);
    }

    public ImageProcessInfo setInputWidth(int width) {
        return this.setValue(ProcessKey.INPUT_WIDTH, width);
    }

    public int getInputHeight() {
        return (Integer)this.getValue(ProcessKey.INPUT_HEIGHT);
    }

    public ImageProcessInfo setInputHeight(int height) {
        return this.setValue(ProcessKey.INPUT_HEIGHT, height);
    }

    public int getOutputWidth() {
        return (Integer)this.getValue(ProcessKey.OUTPUT_WIDTH);
    }

    public ImageProcessInfo setOutputWidth(int width) {
        return this.setValue(ProcessKey.OUTPUT_WIDTH, width);
    }

    public int getOutputHeight() {
        return (Integer)this.getValue(ProcessKey.OUTPUT_HEIGHT);
    }

    public ImageProcessInfo setOutputHeight(int height) {
        return this.setValue(ProcessKey.OUTPUT_HEIGHT, height);
    }

    public byte[] getOutputImage() {
        return (byte[])this.getValue(ProcessKey.OUTPUT_IMAGE);
    }

    public ImageProcessInfo setOutputImage(byte[] outputImage) {
        return this.setValue(ProcessKey.OUTPUT_IMAGE, outputImage);
    }

    public int getOutputImageSize() {
        return (Integer)this.getValue(ProcessKey.OUTPUT_IMAGE_SIZE);
    }

    public ImageProcessInfo setOutputImageSize(int size) {
        return this.setValue(ProcessKey.OUTPUT_IMAGE_SIZE, size);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public static ImageProcessInfo fromMap(Map<String, Object> map) {
        return new ImageProcessInfo(map);
    }

    public static ImageProcessInfo newInstance() {
        return new ImageProcessInfo(new LinkedHashMap<String, Object>());
    }

    public ImageProcessInfo setValue(ProcessKey key, Object value) {
        this.map.put(key.name(), value);
        return this;
    }

    public <T> T getValue(ProcessKey key) {
        Object value = this.map.get(key.name());
        return (T)(value != null ? value : key.defaultValue);
    }

    public String getInputDimension() {
        return this.getInputWidth() + "x" + this.getInputHeight();
    }

    public String getOutputDimension() {
        return this.getOutputWidth() + "x" + this.getOutputHeight();
    }

    public static enum ProcessKey {
        INPUT_WIDTH(0),
        INPUT_HEIGHT(0),
        OUTPUT_WIDTH(0),
        OUTPUT_HEIGHT(0),
        OUTPUT_IMAGE(null),
        OUTPUT_IMAGE_SIZE(0);

        private final Object defaultValue;

        private ProcessKey(Object inValue) {
            this.defaultValue = inValue;
        }
    }
}

