/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    protected static final String MD5 = "MD5";

    public static String getInputStreamMD5(InputStream is) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(MD5);
        try (DigestInputStream dis = new DigestInputStream(is, md);){
            int read;
            byte[] buffer = new byte[4096];
            while ((read = is.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String getInputStreamMD5Quietly(InputStream is) {
        try {
            return DigestUtils.getInputStreamMD5(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFileMD5(File file) throws NoSuchAlgorithmException, IOException {
        return DigestUtils.getInputStreamMD5(new FileInputStream(file));
    }

    public static String getFileMD5Quietly(File file) {
        try {
            return DigestUtils.getInputStreamMD5(new FileInputStream(file));
        }
        catch (Exception e) {
            return null;
        }
    }
}

