/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson15.serializer;

public final class JSONSerializerContext {
    public static final int DEFAULT_TABLE_SIZE = 128;
    private final Entry[] buckets;
    private final int indexMask;

    public JSONSerializerContext() {
        this(128);
    }

    public JSONSerializerContext(int tableSize) {
        this.indexMask = tableSize - 1;
        this.buckets = new Entry[tableSize];
    }

    public final boolean put(Object o) {
        int hash = System.identityHashCode(o);
        int bucket = hash & this.indexMask;
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            if (o == entry.object) {
                return true;
            }
            entry = entry.next;
        }
        this.buckets[bucket] = entry = new Entry(o, hash, this.buckets[bucket]);
        return false;
    }

    protected static final class Entry {
        public final int hashCode;
        public final Object object;
        public Entry next;

        public Entry(Object object, int hash, Entry next) {
            this.object = object;
            this.next = next;
            this.hashCode = hash;
        }
    }
}

