/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson15.serializer;

import com.alibaba.fastjson15.parser.DefaultJSONParser;
import com.alibaba.fastjson15.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson15.serializer.JSONSerializer;
import com.alibaba.fastjson15.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Locale;

public class LocaleCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final LocaleCodec instance = new LocaleCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        Locale locale = (Locale)object;
        serializer.write(locale.toString());
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String text = (String)parser.parse();
        if (text == null) {
            return null;
        }
        String[] items = text.split("_");
        if (items.length == 1) {
            return (T)new Locale(items[0]);
        }
        if (items.length == 2) {
            return (T)new Locale(items[0], items[1]);
        }
        return (T)new Locale(items[0], items[1], items[2]);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

