/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.consumerFinance.v_2.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.consumerFinance.v_2.builder.RepaymentQueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepaymentQueryExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(RepaymentQueryExecuter.class);

    public void query(RepaymentQueryBuilder repaymentQueryBuilder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getConsumerFinanceRepaymentQueryUrl(), repaymentQueryBuilder.encryptBuild());
        LOGGER.info("RepaymentQueryExecuter query responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }
}

