/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.customs.executer;

import com.alibaba.fastjson15.JSONArray;
import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.customs.builder.OrderBuilder;
import com.upay.sdk.customs.builder.QueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.HmacArray;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomsOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(CustomsOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.PAY_SERIAL_NUMBER, Constants.STATUS};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.PAY_SERIAL_NUMBER, HmacArray.create("customsInfos", new String[]{"customsChannel", "amount", "freight", "goodsAmount", "tax", "status"})};

    public void order(JSONObject requestData, ResultListener resultListener) {
        try {
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post(ConfigurationUtils.getCustomsOrderUrl(), requestData.toJSONString());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void callback(JSONObject responseData, ResultListener customsListener) {
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        JSONArray array = responseData.getJSONArray("customsInfos");
        for (Object obj : array) {
            JSONObject customsInfoJson = (JSONObject)obj;
            if (customsInfoJson != null) {
                String status = customsInfoJson.getString("status");
                if (Constants.SUCCESS.equals(status)) {
                    customsListener.success(customsInfoJson);
                    continue;
                }
                if (Constants.PROCESSING.equals(status)) {
                    customsListener.processing(customsInfoJson);
                    continue;
                }
                throw new ResponseException(customsInfoJson);
            }
            LOGGER.info("do nothing.", (Object)customsInfoJson);
        }
    }

    public void query(JSONObject requestData, ResultListener customsListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getCustomsQueryUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.callback(responseData, customsListener);
    }

    public void orderV_3(OrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("CustomsOrderExecuter requestData:[" + requestData.toJSONString() + "],customsOrderUrl:[" + ConfigurationUtils.getCustomsOrderUrl() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCustomsOrderUrl(), requestData);
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void callbackV_3(JSONObject responseData, ResultListener customsListener) {
        LOGGER.info("CustomsOrderExecuter callbackV_3 responseData:[" + responseData + "]");
        if (customsListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CustomsOrderExecuter callbackV_3 data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        JSONArray array = data.getJSONArray("customsInfos");
        for (Object obj : array) {
            JSONObject customsInfoJson = (JSONObject)obj;
            if (customsInfoJson != null) {
                String status = customsInfoJson.getString("status");
                if (Constants.SUCCESS.equals(status)) {
                    customsListener.success(customsInfoJson);
                    continue;
                }
                if (Constants.PROCESSING.equals(status)) {
                    customsListener.processing(customsInfoJson);
                    continue;
                }
                throw new ResponseException(customsInfoJson);
            }
            LOGGER.info("CustomsOrderExecuter do nothing.", (Object)customsInfoJson);
        }
    }

    public void queryV_3(QueryBuilder builder, ResultListener customsListener) {
        if (customsListener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("CustomsOrderExecuter queryV_3 requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCustomsQueryUrl(), requestData);
            LOGGER.debug("CustomsOrderExecuter queryV_3 responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            this.callbackV_3(responseData, customsListener);
        }
        catch (Exception e) {
            LOGGER.error("CustomsOrderExecuter queryv_3 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

