/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class BindCardBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String bankCardNumber;
    private String idCardNumber;
    private String phoneNumber;
    private String bankCode;
    private String name;
    private String userId;
    private String bankCardType;
    private String channelCode;
    private String redirectUrl;
    private String callbackUrl;
    private String notifyUrl;
    private String cvv;
    private String expiredYear;
    private String expiredMonth;

    public BindCardBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    public BindCardBuilder setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber;
        return this;
    }

    public BindCardBuilder setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public BindCardBuilder setBankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    public BindCardBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public BindCardBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public BindCardBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public BindCardBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public BindCardBuilder setBankCardType(String bankCardType) {
        this.bankCardType = bankCardType;
        return this;
    }

    public BindCardBuilder setChannelCode(String channelCode) {
        this.channelCode = channelCode;
        return this;
    }

    public BindCardBuilder setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public BindCardBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public BindCardBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public BindCardBuilder setCvv(String cvv) {
        this.cvv = cvv;
        return this;
    }

    public BindCardBuilder setExpiredYear(String expiredYear) {
        this.expiredYear = expiredYear;
        return this;
    }

    public BindCardBuilder setExpiredMonth(String expiredMonth) {
        this.expiredMonth = expiredMonth;
        return this;
    }

    public BindCardBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

