/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class MerchantCommissionRemitBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String amount;
    private String accountType;
    private String bankCardNumber;
    private String notifyUrl;
    private String remark;

    public MerchantCommissionRemitBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public MerchantCommissionRemitBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MerchantCommissionRemitBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    public MerchantCommissionRemitBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public MerchantCommissionRemitBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public MerchantCommissionRemitBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public MerchantCommissionRemitBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public MerchantCommissionRemitBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountType)) {
            json.put("accountType", (Object)this.accountType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardNumber)) {
            json.put("bankCardNumber", (Object)this.bankCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.bankCardNumber, (String)"")).append(StringUtils.defaultString((String)this.amount, (String)"")).append(StringUtils.defaultString((String)this.accountType, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

