/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class UserRemitBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String amount;
    private String userFeeAmount;
    private String accountName;
    private String bankCardNumber;
    private String bankBranch;
    private String provinceCode;
    private String cityCode;
    private String userId;
    private String notifyUrl;
    private String remark;

    public UserRemitBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public UserRemitBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public UserRemitBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public UserRemitBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    public UserRemitBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public UserRemitBuilder setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
        return this;
    }

    public UserRemitBuilder setCityCode(String cityCode) {
        this.cityCode = cityCode;
        return this;
    }

    public UserRemitBuilder setBankBranch(String bankBranch) {
        this.bankBranch = bankBranch;
        return this;
    }

    public UserRemitBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public UserRemitBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public UserRemitBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public UserRemitBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public UserRemitBuilder setUserFeeAmount(String userFeeAmount) {
        this.userFeeAmount = userFeeAmount;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userFeeAmount)) {
            json.put("userFeeAmount", (Object)this.userFeeAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountName)) {
            json.put("accountName", (Object)this.accountName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardNumber)) {
            json.put("bankCardNumber", (Object)this.bankCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankBranch)) {
            json.put("bankBranch", (Object)this.bankBranch);
        }
        if (StringUtils.isNotBlank((CharSequence)this.provinceCode)) {
            json.put("provinceCode", (Object)this.provinceCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cityCode)) {
            json.put("cityCode", (Object)this.cityCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userId)) {
            json.put("userId", (Object)this.userId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.amount, (String)"")).append(StringUtils.defaultString((String)this.userFeeAmount, (String)"")).append(StringUtils.defaultString((String)this.accountName, (String)"")).append(StringUtils.defaultString((String)this.bankCardNumber, (String)"")).append(StringUtils.defaultString((String)this.bankBranch, (String)"")).append(StringUtils.defaultString((String)this.provinceCode, (String)"")).append(StringUtils.defaultString((String)this.cityCode, (String)"")).append(StringUtils.defaultString((String)this.userId, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

