/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eshopping.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class GetPolicyBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String airlineCode2;
    private String departCode3;
    private String destinationCode3;
    private String fromDate;
    private String arriveDate;
    private Integer adultNum;
    private Integer childNum;
    private Integer babyNum;
    private String flightType;

    public GetPolicyBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public GetPolicyBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public GetPolicyBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public GetPolicyBuilder setAirlineCode2(String airlineCode2) {
        this.airlineCode2 = airlineCode2;
        return this;
    }

    public GetPolicyBuilder setDepartCode3(String departCode3) {
        this.departCode3 = departCode3;
        return this;
    }

    public GetPolicyBuilder setDestinationCode3(String destinationCode3) {
        this.destinationCode3 = destinationCode3;
        return this;
    }

    public GetPolicyBuilder setFromDate(String fromDate) {
        this.fromDate = fromDate;
        return this;
    }

    public GetPolicyBuilder setArriveDate(String arriveDate) {
        this.arriveDate = arriveDate;
        return this;
    }

    public GetPolicyBuilder setAdultNum(Integer adultNum) {
        this.adultNum = adultNum;
        return this;
    }

    public GetPolicyBuilder setChildNum(Integer childNum) {
        this.childNum = childNum;
        return this;
    }

    public GetPolicyBuilder setBabyNum(Integer babyNum) {
        this.babyNum = babyNum;
        return this;
    }

    public GetPolicyBuilder setFlightType(String flightType) {
        this.flightType = flightType;
        return this;
    }
}

