/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eshopping.vcc.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class ApplyVccCardBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String amount;
    private String times;
    private String validity;
    private String userName;
    private String notifyUrl;
    private String cardFirstName;
    private String cardLastName;
    private String currencyType;
    private String accountType;
    private String remark1;
    private String remark2;
    private String remark3;
    private String targetCurrency;
    private String accountSource;

    public ApplyVccCardBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public ApplyVccCardBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public ApplyVccCardBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public String getAmount() {
        return this.amount;
    }

    public ApplyVccCardBuilder setTimes(String times) {
        this.times = times;
        return this;
    }

    public String getValidity() {
        return this.validity;
    }

    public ApplyVccCardBuilder setValidity(String validity) {
        this.validity = validity;
        return this;
    }

    public String getTimes() {
        return this.times;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ApplyVccCardBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public ApplyVccCardBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public ApplyVccCardBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public String getCardFirstName() {
        return this.cardFirstName;
    }

    public ApplyVccCardBuilder setCardFirstName(String cardFirstName) {
        this.cardFirstName = cardFirstName;
        return this;
    }

    public String getCardLastName() {
        return this.cardLastName;
    }

    public ApplyVccCardBuilder setCardLastName(String cardLastName) {
        this.cardLastName = cardLastName;
        return this;
    }

    public String getCurrencyType() {
        return this.currencyType;
    }

    public ApplyVccCardBuilder setCurrencyType(String currencyType) {
        this.currencyType = currencyType;
        return this;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public ApplyVccCardBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public String getRemark1() {
        return this.remark1;
    }

    public void setRemark1(String remark1) {
        this.remark1 = remark1;
    }

    public String getRemark2() {
        return this.remark2;
    }

    public void setRemark2(String remark2) {
        this.remark2 = remark2;
    }

    public String getRemark3() {
        return this.remark3;
    }

    public void setRemark3(String remark3) {
        this.remark3 = remark3;
    }

    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public void setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
    }

    public String getAccountSource() {
        return this.accountSource;
    }

    public void setAccountSource(String accountSource) {
        this.accountSource = accountSource;
    }
}

