/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eshopping.vcc.executer;

import com.alibaba.fastjson15.JSON;
import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.eshopping.vcc.builder.ApplyTransferAmountBuilder;
import com.upay.sdk.eshopping.vcc.builder.ApplyVccCardBuilder;
import com.upay.sdk.eshopping.vcc.builder.CancelVccCardBuilder;
import com.upay.sdk.eshopping.vcc.builder.CancelVccCardQueryBuilder;
import com.upay.sdk.eshopping.vcc.builder.GetAvailableBalanceBuilder;
import com.upay.sdk.eshopping.vcc.builder.GetMerchantListPriceBuilder;
import com.upay.sdk.eshopping.vcc.builder.HistoryConsumeBuilder;
import com.upay.sdk.eshopping.vcc.builder.MiddleMerchantApplyVccCardBuilder;
import com.upay.sdk.eshopping.vcc.builder.MiddleMerchantQueryApplyVccCardBuilder;
import com.upay.sdk.eshopping.vcc.builder.QueryApplyVccCardBuilder;
import com.upay.sdk.eshopping.vcc.builder.VccCardServiceBuilder;
import com.upay.sdk.eshopping.vcc.builder.VccExpenseCreateBuilder;
import com.upay.sdk.eshopping.vcc.builder.VccExpenseQueryBuilder;
import com.upay.sdk.eshopping.vcc.builder.VccRechargetBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EshoppingVccExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(EshoppingVccExecuter.class);

    public void vccRechargeV_3(VccRechargetBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter VccRechargeV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter VccRechargeV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingVccRechargeUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter VccRechargeV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter VccRechargeV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void applyVccCardV_3(ApplyVccCardBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter ApplyVccCardV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter ApplyVccCardV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingApplyVccCardUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter ApplyVccCardV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter ApplyVccCardV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void cancelVccCardV_3(CancelVccCardBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter CancelVccCardV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter CancelVccCardV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingCancelVccCardUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter CancelVccCardV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter CancelVccCardV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void vccCardOrderServiceV_3(VccCardServiceBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter CancelVccCardV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter CancelVccCardV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingVccCardOrderServiceUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter CancelVccCardV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter CancelVccCardV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void queryApplyVccCardV_3(QueryApplyVccCardBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter QueryApplyVccCardV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter QueryApplyVccCardV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingQueryApplyVccCardUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter QueryApplyVccCardV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter QueryApplyVccCardV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void cancelVccCardOrderQueryV_3(CancelVccCardQueryBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter CancelVccCardOrderQueryV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter CancelVccCardOrderQueryV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingCancelVccCardQueryUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter CancelVccCardOrderQueryV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter CancelVccCardOrderQueryV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void vccExpenseCreateV_3(VccExpenseCreateBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter VccExpenseCreateV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter VccExpenseCreateV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingVccExpenseCreateUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter VccExpenseCreateV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter VccExpenseCreateV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void vccExpenseQueryV_3(VccExpenseQueryBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter VccExpenseQueryV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter VccExpenseQueryV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingVccExpenseQueryUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter VccExpenseQueryV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter VccExpenseQueryV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void applyVccCardCallbackV_3(JSONObject responseData, ResultListener listener) {
        LOGGER.info("EshoppingVccExecuter applyVccCardCallbackV_3 responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("EshoppingVccExecuter applyVccCardCallbackV_3 data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        if (data == null) {
            LOGGER.info("EshoppingExecuter applyVccCardCallbackV_3 do nothing.", (Object)data);
            return;
        }
        String status = data.getString(Constants.STATUS);
        if (Constants.NORMAL.equals(status)) {
            listener.success(data);
            return;
        }
        if (!Constants.CANCEL.equals(status)) throw new ResponseException(data);
        listener.failure(data);
    }

    public void transferAmountV_3(ApplyTransferAmountBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter transferAmountV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter transferAmountV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingTransferAmountUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter transferAmountV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter transferAmountV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void getHistoryConsumeV_3(HistoryConsumeBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter getHistoryConsumeV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter getHistoryConsumeV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingHistoryConsumeUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter getHistoryConsumeV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter getHistoryConsumeV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void getAvailableBalanceV_3(GetAvailableBalanceBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter getAvailableBalanceV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter getAvailableBalanceV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingAvailableBalanceUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter getAvailableBalanceV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter getAvailableBalanceV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void getMerchantListPriceV_3(GetMerchantListPriceBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter getMerchantListPriceV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter getMerchantListPriceV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingMerchantListPriceUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter getMerchantListPriceV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter getMerchantListPriceV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void applyCardMiddleMerchantV_3(MiddleMerchantApplyVccCardBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter ApplyCardMiddleMerchantV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter ApplyCardMiddleMerchantV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingMiddleMerchantApplyCardUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter ApplyCardMiddleMerchantV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter ApplyCardMiddleMerchantV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void queryMiddleMerchantApplyCardV_3(MiddleMerchantQueryApplyVccCardBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingVccExecuter QueryMiddleMerchantApplyCardV_3 builder:[" + JSON.toJSONString(builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingVccExecuter QueryMiddleMerchantApplyCardV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingQueryMiddleMerchantApplyCardUrl(), requestData);
        LOGGER.debug("EshoppingVccExecuter QueryMiddleMerchantApplyCardV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingVccExecuter QueryMiddleMerchantApplyCardV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

