/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.foreignexchange.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.Payee;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TransferOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private List<String> originalRequestIds = new LinkedList<String>();
    private String notifyUrl;
    private Payee payee;

    public TransferOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public TransferOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public List<String> getOriginalRequestIds() {
        return this.originalRequestIds;
    }

    public void setOriginalRequestIds(List<String> originalRequestIds) {
        this.originalRequestIds = originalRequestIds;
    }

    public TransferOrderBuilder addOriginalRequestId(String originalRequestId) {
        this.originalRequestIds.add(originalRequestId);
        return this;
    }

    public TransferOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public TransferOrderBuilder setPayee(Payee payee) {
        this.payee = payee;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        json.put("originalRequestIds", (Object)this.originalRequestIds);
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        json.put("payee", (Object)this.payee);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId));
        if (this.originalRequestIds != null) {
            for (String originalRequestId : this.originalRequestIds) {
                hmacSource.append((String)ObjectUtils.defaultIfNull((Object)originalRequestId, (Object)""));
            }
        }
        if (this.payee != null) {
            hmacSource.append(StringUtils.defaultString((String)this.payee.getRecName(), (String)"")).append(StringUtils.defaultString((String)this.payee.getAccountNumber(), (String)"")).append(StringUtils.defaultString((String)this.payee.getRecAddress(), (String)"")).append(StringUtils.defaultString((String)this.payee.getCountryCode(), (String)"")).append(StringUtils.defaultString((String)this.payee.getIbanCode(), (String)"")).append(StringUtils.defaultString((String)this.payee.getBankName(), (String)"")).append(StringUtils.defaultString((String)this.payee.getSwiftCode(), (String)"")).append(StringUtils.defaultString((String)this.payee.getRoutingCode(), (String)"")).append(StringUtils.defaultString((String)this.payee.getBsbCode(), (String)"")).append(StringUtils.defaultString((String)this.payee.getBankAddress(), (String)"")).append(StringUtils.defaultString((String)this.payee.getPostScript(), (String)"")).append(StringUtils.defaultString((String)this.payee.getProxyBankAccountNumber(), (String)"")).append(StringUtils.defaultString((String)this.payee.getProxyBankName(), (String)"")).append(StringUtils.defaultString((String)this.payee.getProxySwiftCode(), (String)"")).append(StringUtils.defaultString((String)this.payee.getProxyBankAddress(), (String)""));
        }
        hmacSource.append(StringUtils.defaultString((String)this.notifyUrl, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

