/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.foreignpayExchangesettlement.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderBatchBuilder
extends BuilderSupport {
    static final Logger LOGGER = LoggerFactory.getLogger(OrderBatchBuilder.class);
    private String requestId;
    private String merchantId;
    private String currency;
    private String amount;
    private String tradeMode;
    private String detailPath;
    private String notifyUrl;
    private String callbackUrl;

    public OrderBatchBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBatchBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public OrderBatchBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public OrderBatchBuilder setTradeMode(String tradeMode) {
        this.tradeMode = tradeMode;
        return this;
    }

    public OrderBatchBuilder setDetailPath(String detailPath) {
        this.detailPath = detailPath;
        return this;
    }

    public OrderBatchBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBatchBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBatchBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject buildRequestData() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantId)) {
            json.put("merchantId", (Object)this.merchantId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.tradeMode)) {
            json.put("tradeMode", (Object)this.tradeMode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.detailPath)) {
            json.put("detailPath", (Object)this.detailPath);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    public String generateHmac() {
        StringBuilder requestBuilder = new StringBuilder();
        requestBuilder.append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.currency)).append(StringUtils.defaultString((String)this.amount)).append(StringUtils.defaultString((String)this.tradeMode)).append(StringUtils.defaultString((String)this.detailPath)).append(StringUtils.defaultString((String)this.notifyUrl)).append(StringUtils.defaultString((String)this.callbackUrl));
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        LOGGER.info("OrderBatchBuilder generateHmac requestBuilder:{},hmacKey:{}", (Object)requestBuilder.toString(), (Object)hmacKey);
        return SignUtils.signMd5(requestBuilder.toString(), hmacKey);
    }
}

