/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.icc.v_3.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.icc.v_3.builder.CashierOrderBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CashierOrderJsonExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(CashierOrderJsonExecuter.class);

    public void bothOrder(CashierOrderBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            LOGGER.info("CashierOrderExecuter START...");
            LOGGER.info("CashierOrderExecuter data:[{}]...", (Object)ToStringBuilder.reflectionToString((Object)builder));
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("CashierOrderExecuter requestData:[" + requestData.toJSONString() + "]");
            String url = ConfigurationUtils.getIccCashierOrderUrl();
            LOGGER.info("CashierOrderExecuter url:[{}]", (Object)url);
            String responseStr = HttpClientUtils.post3(url, requestData);
            LOGGER.info("CashierOrderExecuter responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("CashierOrderExecuter responseStr:[" + responseData + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        listener.success(data);
    }
}

