/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.icc.v_3.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.icc.v_3.builder.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(QueryOrderExecuter.class);

    public void bothQuery(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getIccQueryOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("responseStr:[" + responseData + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothVerifyHmacOrder(responseData);
            if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                listener.success(responseData);
            } else {
                listener.failure(responseData);
            }
        }
        catch (Exception e) {
            LOGGER.error("bothQuery order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

