/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_2.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;

public class JointaccountQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String jointNumber;

    public JointaccountQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JointaccountQueryBuilder setJointNumber(String jointNumber) {
        this.jointNumber = jointNumber;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.jointNumber)) {
            json.put("jointNumber", (Object)this.jointNumber);
        }
        return json;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

