/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_2.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.jointaccount.v_2.builder.QualificationUploadBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QualificationUploadExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(QualificationUploadExecuter.class);

    public void upload(QualificationUploadBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LOGGER.info("url:[" + ConfigurationUtils.getJointUploadQualificationUrl() + "]");
        LOGGER.info("builder.encryptBuild():[" + builder.encryptBuild() + "]");
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getJointUploadQualificationUrl(), builder.encryptBuild());
        LOGGER.info("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (!Constants.SUCCESS.equals(status)) {
            throw new ResponseException(responseData);
        }
        listener.success(responseData);
    }
}

