/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailOrderBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailOrderExtenrGuaranteeBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailOrderGuaranteeFinishBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailOrderQueryBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailOrderRefundBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailRefundOrderQueryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRetailOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(NewRetailOrderExecuter.class);

    public void bothOrder(NewRetailOrderBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailOrderUrl(), requestData);
                LOGGER.debug("responseStr :{}", (Object)responseStr);
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS)) && StringUtils.isEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block5;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothQuery(NewRetailOrderQueryBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailOrderQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.info("responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("bothQuery order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void refund(NewRetailOrderRefundBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailOrderRefundUrl(), requestData);
            LOGGER.debug("responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("responseStr:[" + responseData + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request refund exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void refundQuery(NewRetailRefundOrderQueryBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("refundQuery requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailOrderRefundQueryUrl(), requestData);
            LOGGER.debug("refundQuery responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request refundQuery exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void extendGuarantee(NewRetailOrderExtenrGuaranteeBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("extendGuarantee requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailOrderExtendGuaranteeUrl(), requestData);
            LOGGER.info("extendGuarantee responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request extendGuarantee exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void guaranteeFinish(NewRetailOrderGuaranteeFinishBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("guaranteeFinish requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailGuaranteeFinishUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.info("guaranteeFinish responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("guaranteeFinish decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("guaranteeFinish exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

